/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class LOTREntityAIRangedAttack
extends EntityAIBase {
    private EntityLiving theOwner;
    private IRangedAttackMob theOwnerRanged;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private double moveSpeed;
    private double moveSpeedFlee = 1.5;
    private int repathDelay;
    private int attackTimeMin;
    private int attackTimeMax;
    private float attackRange;
    private float attackRangeSq;

    public LOTREntityAIRangedAttack(IRangedAttackMob entity, double speed, int time, float range) {
        this(entity, speed, time, time, range);
    }

    public LOTREntityAIRangedAttack(IRangedAttackMob entity, double speed, int min, int max, float range) {
        this.theOwnerRanged = entity;
        this.theOwner = (EntityLiving)entity;
        this.moveSpeed = speed;
        this.attackTimeMin = min;
        this.attackTimeMax = max;
        this.attackRange = range;
        this.attackRangeSq = range * range;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theOwner.func_70638_az();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        return true;
    }

    public boolean func_75253_b() {
        if (!this.theOwner.func_70089_S()) {
            return false;
        }
        this.attackTarget = this.theOwner.func_70638_az();
        return this.attackTarget != null && this.attackTarget.func_70089_S();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.repathDelay = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double distanceSq = this.theOwner.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean canSee = this.theOwner.func_70635_at().func_75522_a((Entity)this.attackTarget);
        int n = this.repathDelay = canSee ? (this.repathDelay = this.repathDelay + 1) : 0;
        if (distanceSq <= (double)this.attackRangeSq) {
            if (this.theOwner.func_70068_e((Entity)this.attackTarget) < 25.0) {
                Vec3 vec = LOTREntityAIRangedAttack.findPositionAwayFrom((EntityLivingBase)this.theOwner, this.attackTarget, 8, 16);
                if (vec != null) {
                    this.theOwner.func_70661_as().func_75492_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.moveSpeedFlee);
                }
            } else if (this.repathDelay >= 20) {
                this.theOwner.func_70661_as().func_75499_g();
                this.repathDelay = 0;
            }
        } else {
            this.theOwner.func_70661_as().func_75497_a((Entity)this.attackTarget, this.moveSpeed);
        }
        this.theOwner.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        --this.rangedAttackTime;
        if (this.rangedAttackTime == 0) {
            float distanceRatio;
            if (distanceSq > (double)this.attackRangeSq || !canSee) {
                return;
            }
            float power = distanceRatio = MathHelper.func_76133_a((double)distanceSq) / this.attackRange;
            power = MathHelper.func_76131_a((float)power, (float)0.1f, (float)1.0f);
            this.theOwnerRanged.func_82196_d(this.attackTarget, power);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(distanceRatio * (float)(this.attackTimeMax - this.attackTimeMin) + (float)this.attackTimeMin));
        } else if (this.rangedAttackTime < 0) {
            float distanceRatio = MathHelper.func_76133_a((double)distanceSq) / this.attackRange;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(distanceRatio * (float)(this.attackTimeMax - this.attackTimeMin) + (float)this.attackTimeMin));
        }
    }

    public static Vec3 findPositionAwayFrom(EntityLivingBase entity, EntityLivingBase target, int min, int max) {
        Random random = entity.func_70681_au();
        for (int l = 0; l < 24; ++l) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t) - max + random.nextInt(max * 2 + 1);
            double d = target.func_70092_e((double)i, (double)(j = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b) - 4 + random.nextInt(9)), (double)(k = MathHelper.func_76128_c((double)entity.field_70161_v) - max + random.nextInt(max * 2 + 1)));
            if (d <= (double)(min * min) || d >= (double)(max * max)) continue;
            return Vec3.func_72443_a((double)i, (double)j, (double)k);
        }
        return null;
    }
}

